%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%     Minimax Regret in Practice - Four Examples on Treatment Choice    %%
%%                             Matlab Code                               %%
%%              by Patrick Eozenou, Javier Rivas and Karl Schlag         %%
%%                       2006 - Copyrights reserved                      %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%----------BAR-Paired Sample without Variance Reduction Trick--------------

function[probability_of_choosing_treatment_1] = f_PS_without_VR(treatment_1, treatment_2, ...
    lower_interval, upper_interval, accuracy);

%Making the pairs
n_1 = numel(treatment_1);
n_2 = numel(treatment_2);
montecarlo_pairs = 10^(accuracy/2);
pair = 0;

while pair < montecarlo_pairs;
pair = pair + 1;
mod_treatment_1 = treatment_1;
if n_1 == n_2;
elseif n_1 > n_2;
    difference = n_1 - n_2;
    which_ones_to_drop = randsample(n_1,difference);
    mod_treatment_1(which_ones_to_drop,:) = [];
end;

data = [mod_treatment_1 treatment_2];
truncated_data = data;
n = numel(truncated_data(:,1));
if floor(n/2) < ceil(n/2);
    uneven_sample = randsample(n,1);
    truncated_data(uneven_sample,:) = [];end;
which_ones_to_pair = randsample(floor(n/2)+floor(n/2),floor(n/2));
mod_treatment_1 = truncated_data(which_ones_to_pair,1);
truncated_data(which_ones_to_pair,:) = [];
mod_treatment_2 = truncated_data(:,2);
n = numel(mod_treatment_2);

%Normalizing the value of the treatment samples
normalized_treatment_1 = (mod_treatment_1 - lower_interval) / (upper_interval - lower_interval);
normalized_treatment_2 = (mod_treatment_2 - lower_interval) / (upper_interval - lower_interval);
x = normalized_treatment_1;
y = normalized_treatment_2;

%Computing
montecarlo_shots = 10^(accuracy/2);
shot = 0;
result = 0;
while shot < montecarlo_shots;
shot = shot + 1;
flipping_coins = rand(n,2);

for i=1:1:n;
   if x(i,1) > flipping_coins(i,1);
       binary_x(i,1) = 1;
   else;
       binary_x(i,1) = 0;
   end;
   if y(i,1) > flipping_coins(i,2);
       binary_y(i,1) = 1;
   else;
       binary_y(i,1) = 0;
   end;
end;
sum_binary_x = sum(binary_x);
sum_binary_y = sum(binary_y);

if sum_binary_x > sum_binary_y;
    result = result + (1 / montecarlo_shots);
elseif sum_binary_x < sum_binary_y;
else;
    result = result + (.5 / montecarlo_shots);
end;

end; %Ending the 'choose better treatment' loop
probability_of_choosing_treatment_1_on_this_pair(pair,1) = result;
end; %Ending the 'Making pairs' loop
probability_of_choosing_treatment_1 = sum(probability_of_choosing_treatment_1_on_this_pair) / montecarlo_pairs;